package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@ParametersAreNonnullByDefault
public class MobileRtbBlockActionRestore extends BlockActionRestore<MobileRtbBlock, MobileAppSettings> {
    private final ActionContextFacade actionContextFacade;

    @SuppressWarnings("checkstyle:parameternumber")
    public MobileRtbBlockActionRestore(
            ActionConfiguration<MobileRtbBlock, ?> parentFactory, Collection<Long> containerIds,
            String actionName,
            ActionSetNeedUpdateFactory<MobileRtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
            ActionStartFactory<MobileRtbBlock, BlockStateFlag> actionStartFactory,
            MultistateGraph<MobileRtbBlock, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer, ActionErrorHandler<MobileRtbBlock> actionErrorHandler,
            AgreementChecker agreementChecker,
            UserRoleService userRoleService,
            ActionUserIdContext actionUserIdContext
    ) {
        super(parentFactory, containerIds, actionName, actionSetNeedUpdateFactory, actionStartFactory, multistateGraph,
                actionPerformer, actionErrorHandler, MobileRtbBlock.class, agreementChecker,
                userRoleService, actionUserIdContext);
        this.actionContextFacade = actionPerformer.getActionContextFacade();

    }

    @Override
    protected void incrementPagesCount(Map<Long, Long> pageIds) {
        var pageContainers = actionContextFacade.getActionContext(MobileAppSettings.class)
                .getContainers(StreamEx.of(pageIds.keySet()).toList(), Set.of(ContextPage.BLOCKS_COUNT), true);
        pageContainers.forEach(it ->
                        it.changeProperty(MobileAppSettings.BLOCKS_COUNT,
                                it.getItem().getBlocksCount() + pageIds.get(it.getItem().getId()))
                //TODO: PI-24891 валидация пейджей происходит в валидаторе, однако для балковых операций это может быть
                // проблемой, так как блоки могут записаться в базу а пейджи нет
        );
    }

    @Override
    protected Map<Long, MobileAppSettings> getPages(Set<MobileRtbBlock> blocks) {
        return StreamEx.of(blocks).toMap(MobileRtbBlock::getPageId, MobileRtbBlock::getCampaign);
    }

    @Override
    protected List<BlockType> getBlockTypesForChecker() {
        return List.of(BlockType.MOBILE_APP_RTB);
    }
}
