package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.service.adfox.AdfoxService;

import static ru.yandex.partner.core.entity.block.model.prop.BlockWithPlaceIdPlaceIdPropHolder.PLACE_ID;

@Component
public class MobileRtbBlockDeleteFactory
        extends CustomPayloadActionFactory<MobileRtbBlock, BlockActionDelete<MobileRtbBlock>> {
    private final MobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<MobileRtbBlock> errorHandler;
    private final MobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory;
    private final MobileRtbBlockStopFactory rtbBlockStopFactory;
    private final AdfoxService adfoxService;

    @Autowired
    public MobileRtbBlockDeleteFactory(
            MobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<MobileRtbBlock> errorHandler,
            MobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory,
            MobileRtbBlockStopFactory rtbBlockStopFactory, AdfoxService adfoxService) {
        super(new SmartActionConfigurationFactory<>(
                BlockActionsEnum.DELETE,
                rtbBlockMultistateGraph,
                PLACE_ID
        ));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.rtbBlockSetNeedUpdateFactory = rtbBlockSetNeedUpdateFactory;
        this.rtbBlockStopFactory = rtbBlockStopFactory;
        this.adfoxService = adfoxService;
    }

    @Override
    public BlockActionDelete<MobileRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return delete(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.DELETE.getActionName();
    }

    public BlockActionDelete<MobileRtbBlock> delete(Collection<Long> ids) {
        return new MobileRtbBlockActionDelete(
                getActionConfiguration(),
                getName(),
                ids,
                rtbBlockSetNeedUpdateFactory,
                rtbBlockStopFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                adfoxService
        );
    }

    @Override
    public Class<MobileRtbBlock> getModelClass() {
        return MobileRtbBlock.class;
    }

}
