package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockDuplicateFactory;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;

@Component
public class MobileRtbBlockDuplicateFactory extends BlockDuplicateFactory<MobileRtbBlock> {

    @Autowired
    public MobileRtbBlockDuplicateFactory(
            MobileRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<MobileRtbBlock> actionErrorHandler,
            BlockAddService<BlockWithMultistate> rtbBlockBlockAddService
    ) {
        super(
                new SmartActionConfigurationFactory<>(BlockActionsEnum.DUPLICATE,
                        multistateGraph,
                        MobileRtbBlock.allModelProperties().stream()
                                .map(mp -> (ModelProperty<? super MobileRtbBlock, ?>) mp)
                                .collect(Collectors.toList())
                ),
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                MobileRtbBlock.class,
                MobileAppSettings.class,
                rtbBlockBlockAddService
        );
    }
}
