package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.Collection;
import java.util.stream.Collectors;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionEdit;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.type.update.BlockUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;

@Component
public class MobileRtbBlockEditFactory
        extends ModelPayloadActionFactory<MobileRtbBlock, BlockActionEdit<MobileRtbBlock>> {
    private final MobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<MobileRtbBlock> errorHandler;
    private final ObjectMapper objectMapper;
    private final MobileRtbBlockSetNeedUpdateFactory setNeedUpdateFactory;
    private final BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade;
    private final BlockValidationTypeSupportFacade blockValidationTypeSupportFacade;

    @SuppressWarnings("ParameterNumber")
    @Autowired
    public MobileRtbBlockEditFactory(
            MobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<MobileRtbBlock> errorHandler,
            MobileRtbBlockSetNeedUpdateFactory setNeedUpdateFactory,
            BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade,
            ObjectMapper objectMapper, BlockValidationTypeSupportFacade blockValidationTypeSupportFacade) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.EDIT, rtbBlockMultistateGraph));

        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.objectMapper = objectMapper;
        this.setNeedUpdateFactory = setNeedUpdateFactory;
        this.blockUpdateOperationTypeSupportFacade = blockUpdateOperationTypeSupportFacade;
        this.blockValidationTypeSupportFacade = blockValidationTypeSupportFacade;
    }

    public BlockActionEdit<MobileRtbBlock> edit(
            Collection<? extends ModelChanges<? super MobileRtbBlock>> modelChanges
    ) {
        return edit(modelChanges, new IncomingFields());
    }

    public BlockActionEdit<MobileRtbBlock> edit(
            Collection<? extends ModelChanges<? super MobileRtbBlock>> modelChanges,
            IncomingFields incomingFields
    ) {
        return new BlockActionEdit<>(
                getActionConfiguration(),
                getName(),
                modelChanges.stream().map(it -> it.castModel(MobileRtbBlock.class)).collect(Collectors.toList()),
                incomingFields,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                objectMapper,
                setNeedUpdateFactory,
                blockUpdateOperationTypeSupportFacade,
                MobileRtbBlock.class,
                blockValidationTypeSupportFacade);
    }

    @Override
    public BlockActionEdit<MobileRtbBlock> createAction(
            Collection<ModelChanges<? super MobileRtbBlock>> modelChanges,
            IncomingFields updatedFields
    ) {
        return edit(modelChanges, updatedFields);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.EDIT.getActionName();
    }

    @Override
    public Class<MobileRtbBlock> getModelClass() {
        return MobileRtbBlock.class;
    }
}
