package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.MultistateChangingActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@Component
public class MobileRtbBlockRestoreFactory extends CustomPayloadActionFactory<MobileRtbBlock,
        BlockActionRestore<MobileRtbBlock, MobileAppSettings>>
        implements MultistateChangingActionFactory<MobileRtbBlock, BlockStateFlag> {
    private final MobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<MobileRtbBlock> errorHandler;
    private final MobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory;
    private final MobileRtbBlockStartFactory rtbBlockStartFactory;
    private final AgreementChecker agreementChecker;
    private final UserRoleService userRoleService;
    private final ActionUserIdContext actionUserIdContext;

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public MobileRtbBlockRestoreFactory(
            MobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<MobileRtbBlock> errorHandler,
            MobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory,
            MobileRtbBlockStartFactory rtbBlockStartFactory,
            AgreementChecker agreementChecker,
            UserRoleService userRoleService,
            ActionUserIdContext actionUserIdContext
    ) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.RESTORE, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.rtbBlockSetNeedUpdateFactory = rtbBlockSetNeedUpdateFactory;
        this.rtbBlockStartFactory = rtbBlockStartFactory;
        this.agreementChecker = agreementChecker;
        this.userRoleService = userRoleService;
        this.actionUserIdContext = actionUserIdContext;
    }

    @Override
    public BlockActionRestore<MobileRtbBlock, MobileAppSettings> createAction(Collection<Long> ids) {
        return new MobileRtbBlockActionRestore(
                getActionConfiguration(),
                ids,
                getName(),
                rtbBlockSetNeedUpdateFactory,
                rtbBlockStartFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                agreementChecker,
                userRoleService,
                actionUserIdContext);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.RESTORE.getActionName();
    }

    @Override
    public BlockActionRestore<MobileRtbBlock, MobileAppSettings> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<MobileRtbBlock> getModelClass() {
        return MobileRtbBlock.class;
    }
}
