package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionSetNeedUpdate;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.actions.factory.MobileAppSetNeedUpdateActionFactory;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class MobileRtbBlockSetNeedUpdateFactory
        extends CustomPayloadActionFactory<MobileRtbBlock, BlockActionSetNeedUpdate<MobileRtbBlock, MobileAppSettings>>
        implements ActionSetNeedUpdateFactory<MobileRtbBlock, BlockStateFlag> {
    private final MobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<MobileRtbBlock> errorHandler;
    private final MobileAppSetNeedUpdateActionFactory mobileAppSetNeedUpdateActionFactory;

    @Autowired
    public MobileRtbBlockSetNeedUpdateFactory(MobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
                                              ActionPerformer actionPerformer,
                                              BlockActionErrorHandler<MobileRtbBlock> errorHandler,
                                              MobileAppSetNeedUpdateActionFactory mobileAppSetNeedUpdateActionFactory) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.SET_NEED_UPDATE, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.mobileAppSetNeedUpdateActionFactory = mobileAppSetNeedUpdateActionFactory;
    }

    @Override
    public BlockActionSetNeedUpdate<MobileRtbBlock, MobileAppSettings> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public BlockActionSetNeedUpdate<MobileRtbBlock, MobileAppSettings> createAction(Collection<Long> ids) {
        return new BlockActionSetNeedUpdate<>(
                getActionConfiguration(),
                getName(),
                ids,
                mobileAppSetNeedUpdateActionFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                MobileRtbBlock.class
        );
    }

    @Override
    public Class<MobileRtbBlock> getModelClass() {
        return MobileRtbBlock.class;
    }
}
