package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionStart;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class MobileRtbBlockStartFactory
        extends CustomPayloadActionFactory<MobileRtbBlock, BlockActionStart<MobileRtbBlock>>
        implements ActionStartFactory<MobileRtbBlock, BlockStateFlag> {
    private final MobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<MobileRtbBlock> errorHandler;

    @Autowired
    public MobileRtbBlockStartFactory(
            MobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<MobileRtbBlock> errorHandler
    ) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.START, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public BlockActionStart<MobileRtbBlock> createAction(Collection<Long> ids) {
        return new BlockActionStart<>(
                getActionConfiguration(),
                ids,
                getName(),
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                MobileRtbBlock.class
        );
    }

    @Override
    public String getName() {
        return BlockActionsEnum.START.getActionName();
    }

    @Override
    public BlockActionStart<MobileRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<MobileRtbBlock> getModelClass() {
        return MobileRtbBlock.class;
    }
}
