package ru.yandex.partner.core.entity.block.actions.rtb.mobile.external

import com.fasterxml.jackson.databind.JsonNode
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component
import ru.yandex.partner.core.action.ActionPerformer
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock
import ru.yandex.partner.core.entity.block.model.prop.BlockWithPlaceIdPlaceIdPropHolder
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph
import ru.yandex.partner.core.service.adfox.AdfoxService

@Component
class MobileRtbDeleteFromAdfoxFactory @Autowired constructor(
    private val rtbBlockMultistateGraph: MobileRtbBlockMultistateGraph,
    private val actionPerformer: ActionPerformer,
    private val errorHandler: BlockActionErrorHandler<MobileRtbBlock>,
    private val rtbBlockSetNeedUpdateFactory: MobileRtbBlockSetNeedUpdateFactory,
    private val rtbBlockStopFactory: MobileRtbBlockStopFactory,
    private val adfoxService: AdfoxService
) : CustomPayloadActionFactory<MobileRtbBlock, BlockActionDelete<MobileRtbBlock>>(
    SmartActionConfigurationFactory(
        BlockActionsEnum.DELETE_FROM_ADFOX,
        rtbBlockMultistateGraph,
        BlockWithPlaceIdPlaceIdPropHolder.PLACE_ID
    )
) {

    override fun createAction(ids: List<Long>, payload: JsonNode?): BlockActionDelete<MobileRtbBlock> {
        return MobileRtbBlockActionDelete(
            actionConfiguration,
            name,
            ids,
            rtbBlockSetNeedUpdateFactory,
            rtbBlockStopFactory,
            rtbBlockMultistateGraph,
            actionPerformer,
            errorHandler,
            adfoxService
        )
    }

    override fun getName(): String {
        return BlockActionsEnum.DELETE_FROM_ADFOX.actionName
    }

    override fun getModelClass(): Class<MobileRtbBlock> {
        return MobileRtbBlock::class.java
    }
}
