package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.configuration.annotation.TransactionWithFallbackScope;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionType;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockActionRestoreWithPageFactory;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockMultistateActionFactory;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@Configuration
public class InternalMobileRtbActionsConfiguration {
    private final MultistateGraph<InternalMobileRtbBlock, BlockStateFlag> rtbMultistate;
    private final ActionPerformer actionPerformer;
    private final ActionErrorHandler<InternalMobileRtbBlock> actionErrorHandler;

    public InternalMobileRtbActionsConfiguration(
            MultistateGraph<InternalMobileRtbBlock, BlockStateFlag> rtbMultistate,
            ActionPerformer actionPerformer,
            ActionErrorHandler<InternalMobileRtbBlock> actionErrorHandler
    ) {
        this.rtbMultistate = rtbMultistate;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
    }

    @BlockActionType(BlockActionsEnum.DELETE_WITH_PAGE)
    @Bean
    BlockMultistateActionFactory<InternalMobileRtbBlock> internalMobileRtbBlockMultistateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.DELETE_WITH_PAGE);
    }

    @BlockActionType(BlockActionsEnum.RESTORE_WITH_PAGE)
    @Bean
    BlockActionRestoreWithPageFactory<InternalMobileRtbBlock> internalMobileRtbRestoreWithPageActionFactory(
            InternalMobileRtbBlockStartFactory mobileRtbBlockStartFactory
    ) {
        return new BlockActionRestoreWithPageFactory<>(
                InternalMobileRtbBlock.class,
                rtbMultistate,
                actionPerformer,
                actionErrorHandler,
                mobileRtbBlockStartFactory
        );
    }

    @BlockActionType(BlockActionsEnum.RESET_CHECK_STATISTICS)
    @Bean
    BlockMultistateActionFactory<InternalMobileRtbBlock> internalMobileRtbResetCheckStatisticsActionFactory() {
        return simpleActionFactory(BlockActionsEnum.RESET_CHECK_STATISTICS);
    }

    @BlockActionType(BlockActionsEnum.START_UPDATE)
    @Bean
    BlockMultistateActionFactory<InternalMobileRtbBlock> internalMobileRtbStartUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.START_UPDATE, false);
    }

    @BlockActionType(BlockActionsEnum.STOP_UPDATE)
    @Bean
    BlockMultistateActionFactory<InternalMobileRtbBlock> internalMobileRtbStopUpdateActionFactory() {
        return simpleActionFactory(BlockActionsEnum.STOP_UPDATE, false);
    }

    @TransactionWithFallbackScope
    @Bean
    BlockActionErrorHandler<InternalMobileRtbBlock> internalMobileRtbBlockActionErrorHandler() {
        return new BlockActionErrorHandler<>();
    }

    private BlockMultistateActionFactory<InternalMobileRtbBlock> simpleActionFactory(BlockActionsEnum action) {
        return simpleActionFactory(action, true);
    }

    private BlockMultistateActionFactory<InternalMobileRtbBlock> simpleActionFactory(
            BlockActionsEnum action, boolean writeActionLog) {
        return new BlockMultistateActionFactory<>(
                InternalMobileRtbBlock.class,
                action,
                rtbMultistate,
                actionPerformer,
                actionErrorHandler,
                writeActionLog
        );
    }
}
