package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.function.Function;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.entity.block.InternalMobileRtbCopyMapper;
import ru.yandex.partner.core.entity.block.actions.BlockActionContext;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.service.BlockService;
import ru.yandex.partner.core.entity.block.service.BlockUpdateOperationFactory;

@Component
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InternalMobileRtbBlockActionContext extends BlockActionContext<InternalMobileRtbBlock> {

    @Autowired
    public InternalMobileRtbBlockActionContext(InternalMobileRtbBlockActionsLogger actionsLogger,
                                               ActionErrorHandler<InternalMobileRtbBlock> errorHandler,
                                               BlockService blockService,
                                               InternalMobileRtbCopyMapper mobileRtbCopyMapper,
                                               BlockUpdateOperationFactory blockUpdateOperationFactory) {
        super(actionsLogger, errorHandler, blockService, mobileRtbCopyMapper, blockUpdateOperationFactory);
    }

    @Override
    public Class<InternalMobileRtbBlock> getEntityClass() {
        return InternalMobileRtbBlock.class;
    }

    @Override
    protected Function<Long, BaseBlock> getModelStubCreator() {
        return id -> new InternalMobileRtbBlock().withId(id);
    }
}
