package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.Collection;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStopFactory;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;

@ParametersAreNonnullByDefault
public class InternalMobileRtbBlockActionDelete extends BlockActionDelete<InternalMobileRtbBlock> {

    @SuppressWarnings("checkstyle:parameternumber")
    public InternalMobileRtbBlockActionDelete(
            ActionConfiguration<InternalMobileRtbBlock, ?> parentFactory,
            String actionName,
            Collection<Long> containerIds,
            ActionSetNeedUpdateFactory<InternalMobileRtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
            ActionStopFactory<InternalMobileRtbBlock, BlockStateFlag> blockStopFactory,
            MultistateGraph<InternalMobileRtbBlock, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<InternalMobileRtbBlock> actionErrorHandler) {
        super(parentFactory, actionName, containerIds, actionSetNeedUpdateFactory, blockStopFactory, multistateGraph,
                actionPerformer, actionErrorHandler, InternalMobileRtbBlock.class);
    }

    @Override
    protected void reducePagesCount(Map<Long, Long> pageIds) {
        // has no limits
    }

}
