package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;

import ru.yandex.partner.core.action.ActionConfiguration;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.action.factories.block.ActionStartFactory;
import ru.yandex.partner.core.block.BlockType;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.multistate.graph.MultistateGraph;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@ParametersAreNonnullByDefault
public class InternalMobileRtbBlockActionRestore extends BlockActionRestore<InternalMobileRtbBlock, InternalMobileApp> {

    @SuppressWarnings("checkstyle:parameternumber")
    public InternalMobileRtbBlockActionRestore(
            ActionConfiguration<InternalMobileRtbBlock, ?> parentFactory,
            Collection<Long> containerIds,
            String actionName,
            ActionSetNeedUpdateFactory<InternalMobileRtbBlock, BlockStateFlag> actionSetNeedUpdateFactory,
            ActionStartFactory<InternalMobileRtbBlock, BlockStateFlag> actionStartFactory,
            MultistateGraph<InternalMobileRtbBlock, BlockStateFlag> multistateGraph,
            ActionPerformer actionPerformer, ActionErrorHandler<InternalMobileRtbBlock> actionErrorHandler,
            AgreementChecker agreementChecker,
            UserRoleService userRoleService,
            ActionUserIdContext actionUserIdContext) {

        super(parentFactory, containerIds, actionName, actionSetNeedUpdateFactory, actionStartFactory, multistateGraph,
                actionPerformer, actionErrorHandler, InternalMobileRtbBlock.class, agreementChecker,
                userRoleService, actionUserIdContext);

    }

    @Override
    protected void incrementPagesCount(Map<Long, Long> pageIds) {
        // have no limits
    }

    @Override
    protected Map<Long, InternalMobileApp> getPages(Set<InternalMobileRtbBlock> blocks) {
        return StreamEx.of(blocks).toMap(InternalMobileRtbBlock::getPageId, InternalMobileRtbBlock::getCampaign);
    }

    @Override
    protected List<BlockType> getBlockTypesForChecker() {
        return List.of(BlockType.INTERNAL_MOBILE_APP_RTB);
    }
}
