package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jooq.DSLContext;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.log.AbstractActionsLogger;
import ru.yandex.partner.core.block.BlockUniqueIdConverter;
import ru.yandex.partner.dbschema.partner.Tables;
import ru.yandex.partner.dbschema.partner.tables.records.InternalMobileAppRtbActionLogRecord;
import ru.yandex.partner.defaultconfiguration.PartnerLocalDateTime;

@Component
@DependsOn("partnerLocalDateTime")
@ParametersAreNonnullByDefault
@Scope(ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class InternalMobileRtbBlockActionsLogger extends AbstractActionsLogger<InternalMobileAppRtbActionLogRecord> {

    public InternalMobileRtbBlockActionsLogger(DSLContext dslContext, ActionUserIdContext actionUserIdContext) {
        super(dslContext, Tables.INTERNAL_MOBILE_APP_RTB_ACTION_LOG, actionUserIdContext);
    }

    @Override
    protected InternalMobileAppRtbActionLogRecord getRecord(Long userId, Long modelId, long oldMultistate,
                                                            String actionName, long newMultistate, String opts) {
        var record = new InternalMobileAppRtbActionLogRecord();
        record.setDt(PartnerLocalDateTime.now());
        record.setUserId(userId);
        record.setElemCampaignId(BlockUniqueIdConverter.pageIdFromUniqueId(modelId));
        record.setElemId(BlockUniqueIdConverter.blockIdFromUniqueId(modelId));
        record.setOldMultistate(oldMultistate);
        record.setNewMultistate(newMultistate);
        record.setAction(actionName);
        record.setOpts(opts);
        return record;
    }
}
