package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionContextFacade;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionAdd;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockAddActionFactory;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.entity.page.model.PageWithBlocksLimit;
import ru.yandex.partner.core.service.entitymanager.EntityManager;

@Component
public class InternalMobileRtbBlockAddFactory
        extends CustomPayloadActionFactory<InternalMobileRtbBlock, BlockActionAdd<InternalMobileRtbBlock>>
        implements BlockAddActionFactory<InternalMobileRtbBlock> {

    private final InternalMobileRtbBlockMultistateGraph multistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalMobileRtbBlock> actionErrorHandler;
    private final ObjectMapper objectMapper;
    private final InternalMobileRtbBlockSetNeedUpdateFactory actionSetNeedUpdateFactory;
    private final InternalMobileRtbBlockStartFactory blockStartFactory;
    private final EntityManager entityManager;

    @SuppressWarnings("ParameterNumber")
    @Autowired
    public InternalMobileRtbBlockAddFactory(
            InternalMobileRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalMobileRtbBlock> actionErrorHandler,
            ObjectMapper objectMapper,
            InternalMobileRtbBlockSetNeedUpdateFactory actionSetNeedUpdateFactory,
            InternalMobileRtbBlockStartFactory blockStartFactory, EntityManager entityManager) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.ADD, multistateGraph));
        this.multistateGraph = multistateGraph;
        this.actionPerformer = actionPerformer;
        this.actionErrorHandler = actionErrorHandler;
        this.objectMapper = objectMapper;
        this.actionSetNeedUpdateFactory = actionSetNeedUpdateFactory;
        this.blockStartFactory = blockStartFactory;
        this.entityManager = entityManager;
    }

    @Override
    public String getName() {
        return BlockActionsEnum.ADD.getActionName();
    }

    @Override
    public BlockActionAdd<InternalMobileRtbBlock> createAction(
            Map<Long, InternalMobileRtbBlock> addedModels,
            Map<Long, Set<ModelProperty<? super InternalMobileRtbBlock, ?>>> addedProps
    ) {
        return new BlockActionAdd<>(
                getActionConfiguration(),
                getName(),
                addedModels,
                addedProps,
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                objectMapper,
                InternalMobileRtbBlock.class,
                actionSetNeedUpdateFactory,
                blockStartFactory,
                entityManager, this::incBlocksCount);
    }

    @Override
    public BlockActionAdd<InternalMobileRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        throw new UnsupportedOperationException("InternalMobileRtbBlockAddFactory#createAction");

    }

    @Override
    public Class<InternalMobileRtbBlock> getModelClass() {
        return InternalMobileRtbBlock.class;
    }

    private void incBlocksCount(Map<Long, Long> pageIds, ActionContextFacade actionContextFacade) {
        var pageContainers = actionContextFacade.getActionContext(InternalMobileApp.class)
                .getContainers(
                        pageIds.keySet(),
                        Set.of(PageWithBlocksLimit.BLOCKS_COUNT, BasePage.ID),
                        true
                );
        pageContainers.forEach(it ->
                it.changeProperty(PageWithBlocksLimit.BLOCKS_COUNT,
                        it.getItem().getBlocksCount() + pageIds.get(it.getItem().getId()))
        );
    }
}
