package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionDelete;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;

@Component
public class InternalMobileRtbBlockDeleteFactory
        extends CustomPayloadActionFactory<InternalMobileRtbBlock, BlockActionDelete<InternalMobileRtbBlock>> {
    private final InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler;
    private final InternalMobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory;
    private final InternalMobileRtbBlockStopFactory rtbBlockStopFactory;

    @Autowired
    public InternalMobileRtbBlockDeleteFactory(
            InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler,
            InternalMobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory,
            InternalMobileRtbBlockStopFactory rtbBlockStopFactory) {
        super(new SmartActionConfigurationFactory<>(
                BlockActionsEnum.DELETE,
                rtbBlockMultistateGraph
        ));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.rtbBlockSetNeedUpdateFactory = rtbBlockSetNeedUpdateFactory;
        this.rtbBlockStopFactory = rtbBlockStopFactory;
    }

    @Override
    public BlockActionDelete<InternalMobileRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return delete(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.DELETE.getActionName();
    }

    public BlockActionDelete<InternalMobileRtbBlock> delete(Collection<Long> ids) {
        return new InternalMobileRtbBlockActionDelete(
                getActionConfiguration(),
                getName(),
                ids,
                rtbBlockSetNeedUpdateFactory,
                rtbBlockStopFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler
        );
    }

    @Override
    public Class<InternalMobileRtbBlock> getModelClass() {
        return InternalMobileRtbBlock.class;
    }

}
