package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelProperty;
import ru.yandex.partner.core.action.ActionErrorHandler;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.factories.BlockDuplicateFactory;
import ru.yandex.partner.core.entity.block.model.BlockWithMultistate;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.BlockAddService;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;

@Component
public class InternalMobileRtbBlockDuplicateFactory extends BlockDuplicateFactory<InternalMobileRtbBlock> {

    @Autowired
    public InternalMobileRtbBlockDuplicateFactory(
            InternalMobileRtbBlockMultistateGraph multistateGraph,
            ActionPerformer actionPerformer,
            ActionErrorHandler<InternalMobileRtbBlock> actionErrorHandler,
            BlockAddService<BlockWithMultistate> rtbBlockBlockAddService
    ) {
        super(
                new SmartActionConfigurationFactory<>(BlockActionsEnum.DUPLICATE,
                        multistateGraph,
                        InternalMobileRtbBlock.allModelProperties().stream()
                                .map(mp -> (ModelProperty<? super InternalMobileRtbBlock, ?>) mp)
                                .collect(Collectors.toList())
                ),
                multistateGraph,
                actionPerformer,
                actionErrorHandler,
                InternalMobileRtbBlock.class,
                InternalMobileApp.class,
                rtbBlockBlockAddService
        );
    }
}
