package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.Collection;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.model.ModelChanges;
import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.ModelPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionEdit;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.block.service.type.update.BlockUpdateOperationTypeSupportFacade;
import ru.yandex.partner.core.entity.block.service.validation.type.BlockValidationTypeSupportFacade;

@Component
public class InternalMobileRtbBlockEditFactory
        extends ModelPayloadActionFactory<InternalMobileRtbBlock, BlockActionEdit<InternalMobileRtbBlock>> {
    private final InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler;
    private final ObjectMapper objectMapper;
    private final InternalMobileRtbBlockSetNeedUpdateFactory setNeedUpdateFactory;
    private final BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade;
    private final BlockValidationTypeSupportFacade blockValidationTypeSupportFacade;

    @SuppressWarnings("ParameterNumber")
    @Autowired
    public InternalMobileRtbBlockEditFactory(
            InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler,
            InternalMobileRtbBlockSetNeedUpdateFactory setNeedUpdateFactory,
            BlockUpdateOperationTypeSupportFacade blockUpdateOperationTypeSupportFacade,
            ObjectMapper objectMapper, BlockValidationTypeSupportFacade blockValidationTypeSupportFacade) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.EDIT, rtbBlockMultistateGraph));

        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.objectMapper = objectMapper;
        this.setNeedUpdateFactory = setNeedUpdateFactory;
        this.blockUpdateOperationTypeSupportFacade = blockUpdateOperationTypeSupportFacade;
        this.blockValidationTypeSupportFacade = blockValidationTypeSupportFacade;
    }

    public BlockActionEdit<InternalMobileRtbBlock> edit(
            Collection<? extends ModelChanges<? super InternalMobileRtbBlock>> modelChanges
    ) {
        return edit(modelChanges, new IncomingFields());
    }

    public BlockActionEdit<InternalMobileRtbBlock> edit(
            Collection<? extends ModelChanges<? super InternalMobileRtbBlock>> modelChanges,
            IncomingFields incomingFields
    ) {
        return new BlockActionEdit<>(
                getActionConfiguration(),
                getName(),
                modelChanges.stream().map(it -> it.castModel(InternalMobileRtbBlock.class)).toList(),
                incomingFields,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                objectMapper,
                setNeedUpdateFactory,
                blockUpdateOperationTypeSupportFacade,
                InternalMobileRtbBlock.class,
                blockValidationTypeSupportFacade);
    }

    @Override
    public BlockActionEdit<InternalMobileRtbBlock> createAction(
            Collection<ModelChanges<? super InternalMobileRtbBlock>> modelChanges,
            IncomingFields updatedFields
    ) {
        return edit(modelChanges, updatedFields);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.EDIT.getActionName();
    }

    @Override
    public Class<InternalMobileRtbBlock> getModelClass() {
        return InternalMobileRtbBlock.class;
    }
}
