package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.ActionUserIdContext;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.MultistateChangingActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.entity.agreement.service.AgreementChecker;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionRestore;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.libs.rbac.userrole.UserRoleService;

@Component
public class InternalMobileRtbBlockRestoreFactory extends CustomPayloadActionFactory<InternalMobileRtbBlock,
        BlockActionRestore<InternalMobileRtbBlock, InternalMobileApp>>
        implements MultistateChangingActionFactory<InternalMobileRtbBlock, BlockStateFlag> {
    private final InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler;
    private final InternalMobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory;
    private final InternalMobileRtbBlockStartFactory rtbBlockStartFactory;
    private final AgreementChecker agreementChecker;
    private final UserRoleService userRoleService;
    private final ActionUserIdContext actionUserIdContext;

    @Autowired
    @SuppressWarnings("checkstyle:parameternumber")
    public InternalMobileRtbBlockRestoreFactory(
            InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler,
            InternalMobileRtbBlockSetNeedUpdateFactory rtbBlockSetNeedUpdateFactory,
            InternalMobileRtbBlockStartFactory rtbBlockStartFactory,
            AgreementChecker agreementChecker,
            UserRoleService userRoleService,
            ActionUserIdContext actionUserIdContext
    ) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.RESTORE, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.rtbBlockSetNeedUpdateFactory = rtbBlockSetNeedUpdateFactory;
        this.rtbBlockStartFactory = rtbBlockStartFactory;
        this.agreementChecker = agreementChecker;
        this.userRoleService = userRoleService;
        this.actionUserIdContext = actionUserIdContext;
    }

    @Override
    public BlockActionRestore<InternalMobileRtbBlock, InternalMobileApp> createAction(Collection<Long> ids) {
        return new InternalMobileRtbBlockActionRestore(
                getActionConfiguration(),
                ids,
                getName(),
                rtbBlockSetNeedUpdateFactory,
                rtbBlockStartFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                agreementChecker,
                userRoleService,
                actionUserIdContext);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.RESTORE.getActionName();
    }

    @Override
    public BlockActionRestore<InternalMobileRtbBlock, InternalMobileApp> createAction(
            List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<InternalMobileRtbBlock> getModelClass() {
        return InternalMobileRtbBlock.class;
    }
}
