package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionSetCheckStatisticsFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionStart;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class InternalMobileRtbBlockSetCheckStatisticsFactory
        extends CustomPayloadActionFactory<InternalMobileRtbBlock, BlockActionStart<InternalMobileRtbBlock>>
        implements ActionSetCheckStatisticsFactory<InternalMobileRtbBlock, BlockStateFlag> {
    private final InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler;

    @Autowired
    public InternalMobileRtbBlockSetCheckStatisticsFactory(
            InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.SET_CHECK_STATISTICS, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
    }

    @Override
    public BlockActionStart<InternalMobileRtbBlock> createAction(Collection<Long> ids) {
        return new BlockActionStart<>(
                getActionConfiguration(),
                ids,
                getName(),
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                InternalMobileRtbBlock.class
        );
    }

    @Override
    public String getName() {
        return BlockActionsEnum.SET_CHECK_STATISTICS.getActionName();
    }

    @Override
    public BlockActionStart<InternalMobileRtbBlock> createAction(List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public Class<InternalMobileRtbBlock> getModelClass() {
        return InternalMobileRtbBlock.class;
    }
}
