package ru.yandex.partner.core.entity.block.actions.rtb.mobile.internal;

import java.util.Collection;
import java.util.List;

import com.fasterxml.jackson.databind.JsonNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.action.ActionPerformer;
import ru.yandex.partner.core.action.factories.CustomPayloadActionFactory;
import ru.yandex.partner.core.action.factories.SmartActionConfigurationFactory;
import ru.yandex.partner.core.action.factories.block.ActionSetNeedUpdateFactory;
import ru.yandex.partner.core.entity.block.actions.BlockActionErrorHandler;
import ru.yandex.partner.core.entity.block.actions.BlockActionsEnum;
import ru.yandex.partner.core.entity.block.actions.all.BlockActionSetNeedUpdate;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.entity.page.actions.factory.InternalMobileAppSetNeedUpdateActionFactory;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

@Component
public class InternalMobileRtbBlockSetNeedUpdateFactory
        extends CustomPayloadActionFactory<InternalMobileRtbBlock,
        BlockActionSetNeedUpdate<InternalMobileRtbBlock, InternalMobileApp>>
        implements ActionSetNeedUpdateFactory<InternalMobileRtbBlock, BlockStateFlag> {
    private final InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph;
    private final ActionPerformer actionPerformer;
    private final BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler;
    private final InternalMobileAppSetNeedUpdateActionFactory mobileAppSetNeedUpdateActionFactory;

    @Autowired
    public InternalMobileRtbBlockSetNeedUpdateFactory(
            InternalMobileRtbBlockMultistateGraph rtbBlockMultistateGraph,
            ActionPerformer actionPerformer,
            BlockActionErrorHandler<InternalMobileRtbBlock> errorHandler,
            InternalMobileAppSetNeedUpdateActionFactory mobileAppSetNeedUpdateActionFactory) {
        super(new SmartActionConfigurationFactory<>(BlockActionsEnum.SET_NEED_UPDATE, rtbBlockMultistateGraph));
        this.rtbBlockMultistateGraph = rtbBlockMultistateGraph;
        this.actionPerformer = actionPerformer;
        this.errorHandler = errorHandler;
        this.mobileAppSetNeedUpdateActionFactory = mobileAppSetNeedUpdateActionFactory;
    }

    @Override
    public BlockActionSetNeedUpdate<InternalMobileRtbBlock, InternalMobileApp> createAction(
            List<Long> ids, JsonNode payload) {
        return createAction(ids);
    }

    @Override
    public String getName() {
        return BlockActionsEnum.SET_NEED_UPDATE.getActionName();
    }

    @Override
    public BlockActionSetNeedUpdate<InternalMobileRtbBlock, InternalMobileApp> createAction(Collection<Long> ids) {
        return new BlockActionSetNeedUpdate<>(
                getActionConfiguration(),
                getName(),
                ids,
                mobileAppSetNeedUpdateActionFactory,
                rtbBlockMultistateGraph,
                actionPerformer,
                errorHandler,
                InternalMobileRtbBlock.class
        );
    }

    @Override
    public Class<InternalMobileRtbBlock> getModelClass() {
        return InternalMobileRtbBlock.class;
    }
}
