package ru.yandex.partner.core.entity.block.container

import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions
import ru.yandex.partner.core.entity.geo.GeoBaseDto
import ru.yandex.partner.core.entity.utils.CpmUtils

/**
 * Контейнер для справочников и сущностей при заполнении БК даты
 */
class BlockBkDictContainer {
    lateinit var piCategoryDict: Map<Long, CpmUtils.CpmNode>
    lateinit var geoBases: Map<Boolean, List<GeoBaseDto>>
    lateinit var pageIdsToIsCrimeaRussian: Map<Long, Boolean>
    lateinit var customBkOptions: List<CustomBkOptions>

    fun withPiCategoryDict(dict: Map<Long, CpmUtils.CpmNode>) {
        this.piCategoryDict = dict
    }

    fun withGeoBase(rawGeoBase: Map<Boolean, List<GeoBaseDto>>) {
        if (!this::geoBases.isInitialized) {
            this.geoBases = rawGeoBase
        }
    }

    fun getGeoBase(isCrimeaRussian: Boolean): List<GeoBaseDto> {
        return geoBases.getValue(isCrimeaRussian)
    }

    fun withPageIdsToIsCrimeaRussian(pageIdsToIsCrimeaRussian: Map<Long, Boolean>) {
        if (!this::pageIdsToIsCrimeaRussian.isInitialized) {
            this.pageIdsToIsCrimeaRussian = pageIdsToIsCrimeaRussian
        }
    }

    fun withCustomBkOptions(customBkOptions: List<CustomBkOptions>) {
        if (!this::customBkOptions.isInitialized) {
            this.customBkOptions = customBkOptions
        }
    }
}
