package ru.yandex.partner.core.entity.block.container;

import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.multitype.repository.container.RepositoryContainer;
import ru.yandex.direct.multitype.service.type.update.UpdateOperationContainer;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.operation.container.ModeContainer;

public interface BlockContainer extends UpdateOperationContainer<BaseBlock>, RepositoryContainer,
        IncomingFieldsContainer, ModeContainer {

    Set<Long> getAvailableBrandIds();

    void setAvailableBrandIds(Set<Long> availableBrandIds);

    Map<Long, Set<String>> getFeaturesAndOptions();

    void setFeaturesAndOptions(Map<Long, Set<String>> featuresAndOptions);

    Map<Long, String> getSiteVersions();

    void setSiteVersions(Map<Long, String> siteVersions);

    Map<Long, Boolean> getShowVideo();

    void setShowVideo(Map<Long, Boolean> showVideo);

    Map<Class<? extends BaseBlock>, Boolean> getCanValidateDesignAsManager();

    boolean getCanValidateDesignAsManager(Class<? extends BaseBlock> clazz);

    void setCanValidateDesignAsManager(Map<Class<? extends BaseBlock>, Boolean> canValidateDesignAsManager);

    Map<Long, List<DesignTemplates>> getUnmodifiedTemplates();

    void setUnmodifiedTemplates(Map<Long, List<DesignTemplates>> unmodifiedTemplates);

    void setPages(Map<Long, ContextPage> pages);

    Set<Long> getAvailablePiCategoriesIds();

    void setAvailablePiCategoriesIds(Set<Long> availablePiCategoriesIds);

    Set<Long> getAvailableGeoIds();

    void setAvailableGeoIds(Set<Long> availableGeoIds);

    Set<Long> getAvailableTagIds();

    void setAvailableTagIds(Set<Long> availableTagIds);

    Map<Long, CustomBkOptions> getCustomBkOptions();

    void setCustomBkOptions(Map<Long, CustomBkOptions> customBkOptions);

    Map<Long, Dsp> getDsps();

    void setDsps(Map<Long, Dsp> dsps);

    Map<Long, Dsp> getNotDeletedDsps();

    void setNotDeletedDsps(Map<Long, Dsp> notDeleteDsps);

    Map<Long, List<Dsp>> getBlockAvailableDsps();

    void setBlockAvailableDsps(Map<Long, List<Dsp>> blockAvailableDsps);

    CoreFilterNode<? extends BasePage> getPageReachabilityFilter(Class<? extends BaseBlock> clazz);

    Map<Class<? extends BaseBlock>, CoreFilterNode<? extends BasePage>> getPageReachabilityFilter();

    void setPageReachabilityFilter(Map<Class<? extends BaseBlock>, CoreFilterNode<? extends BasePage>> basePageFilter);

    Map<Class<? extends BaseBlock>, Map<Long, ? extends PageWithOwner>> getReachablePages();

    Map<Class<? extends BaseBlock>, Boolean> getCanEditRichMedia();

    boolean canEditRichMedia(Class<? extends BaseBlock> clazz);

    void setCanEditRichMedia(Map<Class<? extends BaseBlock>, Boolean> canEditRichMedia);

    Boolean getIsValidatingBkData(Long id);

    void setValidatingBkDataMap(Map<Long, Boolean> isValidatingBkData);

    Map<Long, Boolean> getValidatingBkDataMap();
}
