package ru.yandex.partner.core.entity.block.container;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.validation.constraints.NotNull;

import ru.yandex.partner.core.entity.IncomingFields;
import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.service.OperationMode;
import ru.yandex.partner.core.entity.custombkoptions.model.CustomBkOptions;
import ru.yandex.partner.core.entity.designtemplates.model.DesignTemplates;
import ru.yandex.partner.core.entity.dsp.model.Dsp;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.entity.page.model.PageWithOwner;
import ru.yandex.partner.core.filter.CoreFilterNode;

public class BlockContainerImpl implements BlockContainer {
    private OperationMode mode;
    private Set<Long> availableBrandIds = new HashSet<>();
    private Map<Long, Set<String>> featuresAndOptions = new HashMap<>();
    private Map<Long, String> siteVersions = new HashMap<>();
    private Map<Long, Boolean> showVideo = new HashMap<>();
    private Map<Long, List<DesignTemplates>> unmodifiedTemplates = new HashMap<>();
    private Map<Class<? extends BaseBlock>, Boolean> canValidateDesignAsManager = new HashMap<>();
    private Set<Long> availableTagIds = new HashSet<>();
    private Set<Long> availablePiCategoriesIds;
    private Set<Long> availableGeoIds;
    private Map<Long, CustomBkOptions> customBkOptions = new HashMap<>();

    private Map<Long, Dsp> dsps;
    private Map<Long, Dsp> notDeletedDsps;
    private Map<Long, List<Dsp>> blockAvailableDsps;

    private Map<Class<? extends BaseBlock>, CoreFilterNode<? extends BasePage>> pageReachabilityFilter =
            new HashMap<>();
    private Map<Class<? extends BaseBlock>, Map<Long, ? extends PageWithOwner>> reachablePages = new HashMap<>();
    private Map<Long, Boolean> validatingBkDataMap = new HashMap<>();


    private IncomingFields incomingFields;

    private Map<Class<? extends BaseBlock>, Boolean> canEditRichMedia = new HashMap<>();

    public static BlockContainerImpl create(OperationMode mode) {
        var container = new BlockContainerImpl();
        container.mode = mode;
        return container;
    }

    public static BlockContainerImpl copy(BlockContainer container) {
        var copy = new BlockContainerImpl();
        copy.mode = container.getMode();
        copy.canValidateDesignAsManager = container.getCanValidateDesignAsManager();
        copy.availableBrandIds = container.getAvailableBrandIds();
        copy.featuresAndOptions = container.getFeaturesAndOptions();
        copy.siteVersions = container.getSiteVersions();
        copy.showVideo = container.getShowVideo();
        copy.unmodifiedTemplates = container.getUnmodifiedTemplates();
        copy.availableTagIds = container.getAvailableTagIds();
        copy.availablePiCategoriesIds = container.getAvailablePiCategoriesIds();
        copy.availableGeoIds = container.getAvailableGeoIds();
        copy.canEditRichMedia = container.getCanEditRichMedia();
        copy.pageReachabilityFilter = container.getPageReachabilityFilter();
        copy.validatingBkDataMap = container.getValidatingBkDataMap();
        return copy;
    }

    @Override
    public OperationMode getMode() {
        return mode;
    }

    @Override
    public int getShard() {
        return 0;
    }

    @Override
    public Class<? extends BaseBlock> getRuntimeClass(@NotNull Long modelId) {
        return RtbBlock.class;
    }

    @Override
    public Set<Long> getAvailableBrandIds() {
        return availableBrandIds;
    }

    @Override
    public void setAvailableBrandIds(Set<Long> availableBrandIds) {
        this.availableBrandIds = availableBrandIds;
    }

    @Override
    public Set<Long> getAvailablePiCategoriesIds() {
        return availablePiCategoriesIds;
    }

    @Override
    public void setAvailablePiCategoriesIds(Set<Long> availablePiCategoriesIds) {
        this.availablePiCategoriesIds = availablePiCategoriesIds;
    }

    @Override
    public Set<Long> getAvailableGeoIds() {
        return availableGeoIds;
    }

    @Override
    public void setAvailableGeoIds(Set<Long> availableGeoIds) {
        this.availableGeoIds = availableGeoIds;
    }

    @Override
    public Map<Long, Set<String>> getFeaturesAndOptions() {
        return featuresAndOptions;
    }

    @Override
    public void setFeaturesAndOptions(Map<Long, Set<String>> featuresAndOptions) {
        this.featuresAndOptions = featuresAndOptions;
    }

    @Override
    public Map<Long, String> getSiteVersions() {
        return siteVersions;
    }

    @Override
    public void setSiteVersions(Map<Long, String> siteVersions) {
        this.siteVersions = siteVersions;
    }

    @Override
    public Map<Long, Boolean> getShowVideo() {
        return showVideo;
    }

    @Override
    public void setShowVideo(Map<Long, Boolean> showVideo) {
        this.showVideo = showVideo;
    }

    @Override
    public Map<Class<? extends BaseBlock>, Boolean> getCanValidateDesignAsManager() {
        return canValidateDesignAsManager;
    }

    @Override
    public boolean getCanValidateDesignAsManager(Class<? extends BaseBlock> blockClass) {
        return mode == OperationMode.CRON || canValidateDesignAsManager.getOrDefault(blockClass, false);
    }

    @Override
    public void setCanValidateDesignAsManager(Map<Class<? extends BaseBlock>, Boolean> canValidateDesignAsManager) {
        this.canValidateDesignAsManager = canValidateDesignAsManager;
    }

    @Override
    public Map<Long, List<DesignTemplates>> getUnmodifiedTemplates() {
        return unmodifiedTemplates;
    }

    @Override
    public void setUnmodifiedTemplates(Map<Long, List<DesignTemplates>> unmodifiedTemplates) {
        this.unmodifiedTemplates = unmodifiedTemplates;
    }

    @Override
    public void setPages(Map<Long, ContextPage> pages) {
    }

    @Override
    public Set<Long> getAvailableTagIds() {
        return availableTagIds;
    }

    @Override
    public void setAvailableTagIds(Set<Long> availableTagIds) {
        this.availableTagIds = availableTagIds;
    }

    @Override
    public Map<Long, CustomBkOptions> getCustomBkOptions() {
        return customBkOptions;
    }

    @Override
    public void setCustomBkOptions(Map<Long, CustomBkOptions> customBkOptions) {
        this.customBkOptions = customBkOptions;
    }

    @Override
    public Map<Long, Dsp> getDsps() {
        return dsps;
    }

    @Override
    public void setDsps(Map<Long, Dsp> dsps) {
        this.dsps = dsps;
    }

    @Override
    public Map<Long, Dsp> getNotDeletedDsps() {
        return notDeletedDsps;
    }

    @Override
    public void setNotDeletedDsps(Map<Long, Dsp> notDeletedDsps) {
        this.notDeletedDsps = notDeletedDsps;
    }

    @Override
    public Map<Long, List<Dsp>> getBlockAvailableDsps() {
        return blockAvailableDsps;
    }

    @Override
    public void setBlockAvailableDsps(Map<Long, List<Dsp>> blockAvailableDsps) {
        this.blockAvailableDsps = blockAvailableDsps;
    }

    @Override
    public CoreFilterNode<? extends BasePage> getPageReachabilityFilter(Class<? extends BaseBlock> clazz) {
        return pageReachabilityFilter.getOrDefault(clazz, CoreFilterNode.neutral());
    }

    @Override
    public Map<Class<? extends BaseBlock>, CoreFilterNode<? extends BasePage>> getPageReachabilityFilter() {
        return pageReachabilityFilter;
    }

    @Override
    public void setPageReachabilityFilter(@NotNull Map<Class<? extends BaseBlock>,
            CoreFilterNode<? extends BasePage>> basePageFilter) {
        this.pageReachabilityFilter = basePageFilter;
    }

    @Override
    public Map<Class<? extends BaseBlock>, Map<Long, ? extends PageWithOwner>> getReachablePages() {
        return reachablePages;
    }

    @Override
    public Map<Class<? extends BaseBlock>, Boolean> getCanEditRichMedia() {
        return canEditRichMedia;
    }

    @Override
    public boolean canEditRichMedia(Class<? extends BaseBlock> blockClass) {

        return canEditRichMedia.getOrDefault(blockClass, false);
    }

    @Override
    public void setCanEditRichMedia(Map<Class<? extends BaseBlock>, Boolean> canEditRichMedia) {
        this.canEditRichMedia = canEditRichMedia;
    }

    @Override
    public IncomingFields getIncomingFields() {
        return incomingFields;
    }

    @Override
    public void setIncomingFields(IncomingFields incomingFields) {
        this.incomingFields = incomingFields;
    }

    @Override
    public Boolean getIsValidatingBkData(Long id) {
        return validatingBkDataMap.getOrDefault(id, true);
    }

    @Override
    public void setValidatingBkDataMap(Map<Long, Boolean> validatingBkDataMap) {
        this.validatingBkDataMap = validatingBkDataMap;
    }

    @Override
    public Map<Long, Boolean> getValidatingBkDataMap() {
        return validatingBkDataMap;
    }
}
