package ru.yandex.partner.core.entity.block.filter;

import java.math.BigDecimal;

import org.jooq.impl.DSL;
import org.jooq.impl.SQLDataType;

import ru.yandex.partner.core.entity.block.model.BaseBlock;
import ru.yandex.partner.core.entity.block.model.BlockWithAdfox;
import ru.yandex.partner.core.entity.block.model.BlockWithBlockType;
import ru.yandex.partner.core.entity.block.model.BlockWithCommonFields;
import ru.yandex.partner.core.entity.block.model.BlockWithSiteVersion;
import ru.yandex.partner.core.entity.page.filter.ManagerLoginFilter;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.user.filter.UserType;
import ru.yandex.partner.core.filter.CoreFilterNode;
import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BooleanFilter;
import ru.yandex.partner.core.filter.dbmeta.NumberFilter;
import ru.yandex.partner.core.filter.dbmeta.PublicIdFilter;
import ru.yandex.partner.core.filter.dbmeta.StringFilter;
import ru.yandex.partner.core.filter.meta.BooleanMetaFilter;
import ru.yandex.partner.core.filter.meta.MatchMetaFilter;
import ru.yandex.partner.core.filter.meta.MetaFilter;
import ru.yandex.partner.core.filter.meta.MultistateMetaFilter;
import ru.yandex.partner.core.filter.meta.NumberMetaFilter;
import ru.yandex.partner.core.filter.meta.StringMetaFilter;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;
import ru.yandex.partner.dbschema.partner.enums.ContextOnSiteRtbSiteVersion;

import static ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb.CONTEXT_ON_SITE_RTB;

public class BlockFilters {
    public static final NumberFilter<BaseBlock, Long> ID
            = new NumberFilter<>("id", BaseBlock.class, CONTEXT_ON_SITE_RTB.UNIQUE_ID);

    public static final NumberFilter<BaseBlock, Long> BLOCK_ID
            = new NumberFilter<>("block_id", BaseBlock.class, CONTEXT_ON_SITE_RTB.ID);

    public static final PublicIdFilter<BaseBlock> PUBLIC_ID
            = new PublicIdFilter<>("public_id", BaseBlock.class, ID, BLOCK_ID);

    public static final NumberFilter<BaseBlock, Long> PLACE_ID
            = new NumberFilter<>("place_id", BaseBlock.class, CONTEXT_ON_SITE_RTB.PLACE_ID);

    public static final MetaFilter<BaseBlock, CoreFilterNode<BasePage>> PAGE = new MatchMetaFilter<>("page",
            BaseBlock.class);

    public static final NumberFilter<BaseBlock, Long> PAGE_ID = new NumberFilter<>("page_id", BaseBlock.class,
            CONTEXT_ON_SITE_RTB.CAMPAIGN_ID);

    public static final NumberFilter<BaseBlock, Long> CAMPAIGN_ID = new NumberFilter<>("campaign_id",
            BaseBlock.class, CONTEXT_ON_SITE_RTB.CAMPAIGN_ID);

    public static final StringFilter<BlockWithCommonFields> CAPTION = new StringFilter<>("caption", BaseBlock.class,
            CONTEXT_ON_SITE_RTB.CAPTION);

    public static final BooleanFilter<BaseBlock> ACTIVE = new BooleanFilter<>("active", BaseBlock.class,
            CONTEXT_ON_SITE_RTB.ACTIVE);

    public static final BooleanFilter<BlockWithAdfox> ADFOX_BLOCK = new BooleanFilter<>("adfox_block",
            BlockWithAdfox.class, CONTEXT_ON_SITE_RTB.ADFOX_BLOCK);

    public static final MultistateMetaFilter<BaseBlock, BlockStateFlag> MULTISTATE =
            new MultistateMetaFilter<>("multistate", BaseBlock.class);

    public static final SiteVersionFilter<BlockWithSiteVersion, ContextOnSiteRtbSiteVersion> SITE_VERSION
            = new SiteVersionFilter<>("site_version", BlockWithSiteVersion.class,
            ContextOnSiteRtbSiteVersion.class, CONTEXT_ON_SITE_RTB.SITE_VERSION);

    public static final NumberFilter<BaseBlock, Long> STRATEGY = new NumberFilter<>("strategy",
            FilterType.DICTIONARY, BaseBlock.class, CONTEXT_ON_SITE_RTB.STRATEGY);

    public static final NumberFilter<BaseBlock, BigDecimal> MIN_CPM = new NumberFilter<>("mincpm", BaseBlock.class,
            CONTEXT_ON_SITE_RTB.MINCPM);

    public static final NumberFilter<BaseBlock, BigDecimal> TEXT_CPM = new NumberFilter<>("text_cpm",
            BaseBlock.class, CONTEXT_ON_SITE_RTB.TEXT_CPM);

    public static final BooleanFilter<BaseBlock> TEXT_BLOCKED = new BooleanFilter<>("text_blocked", BaseBlock.class,
            CONTEXT_ON_SITE_RTB.TEXT_BLOCKED);

    public static final NumberFilter<BaseBlock, BigDecimal> MEDIA_CPM = new NumberFilter<>("media_cpm",
            BaseBlock.class, CONTEXT_ON_SITE_RTB.MEDIA_CPM);

    public static final BooleanFilter<BaseBlock> MEDIA_BLOCKED = new BooleanFilter<>("media_blocked",
            BaseBlock.class, CONTEXT_ON_SITE_RTB.MEDIA_BLOCKED);

    public static final NumberFilter<BaseBlock, BigDecimal> VIDEO_CPM = new NumberFilter<>("video_cpm",
            BaseBlock.class, CONTEXT_ON_SITE_RTB.VIDEO_CPM);

    public static final BooleanFilter<BaseBlock> VIDEO_BLOCKED = new BooleanFilter<>("video_blocked",
            BaseBlock.class, CONTEXT_ON_SITE_RTB.VIDEO_BLOCKED);

    public static final StringMetaFilter<BaseBlock> LOGIN = new StringMetaFilter<>("login", FilterType.LOGIN,
            BaseBlock.class);

    public static final MetaFilter<BaseBlock, Long> CLIENT_ID = new MetaFilter<>("client_id", FilterType.NUMBER,
            BaseBlock.class, Long.class);

    public static final MetaFilter<BaseBlock, UserType> USER_TYPE = new MetaFilter<>("user_type",
            FilterType.DICTIONARY, BaseBlock.class, UserType.class);

    public static final NumberMetaFilter<BaseBlock, Long> OWNER_ID =
            new NumberMetaFilter<>("owner_id", BaseBlock.class, Long.class);

    public static final BooleanMetaFilter<BaseBlock> IS_YANDEX_BLOCK =
            new BooleanMetaFilter<>("is_yandex_block", BaseBlock.class);

    public static final ManagerLoginFilter<BaseBlock> MANAGER_LOGIN =
            new ManagerLoginFilter<>("manager_login", BaseBlock.class);

    public static final BooleanFilter<BaseBlock> IS_MOBILE_MEDIATION = new BooleanFilter<>("is_mobile_mediation",
            BaseBlock.class,
            DSL.jsonValue(CONTEXT_ON_SITE_RTB.OPTS.cast(SQLDataType.JSON), "$.is_mobile_mediation")
                    .cast(SQLDataType.BIGINT));

    public static final StringFilter<BlockWithBlockType> BLOCK_TYPE = new StringFilter<>("block_type",
            BlockWithBlockType.class, CONTEXT_ON_SITE_RTB.BLOCK_TYPE);

    public static final StringFilter<BaseBlock> MODEL = new StringFilter("model", BaseBlock.class,
            CONTEXT_ON_SITE_RTB.MODEL);

    public static final NumberMetaFilter<BaseBlock, Long> APP_ID = new NumberMetaFilter<>("app_id",
            BaseBlock.class, Long.class);

    public static final StringMetaFilter<BaseBlock> DOMAIN = new StringMetaFilter<>("domain",
            BaseBlock.class);

    public static final NumberMetaFilter<BaseBlock, Long> PLATFORM = new NumberMetaFilter<>("platform",
            FilterType.DICTIONARY, BaseBlock.class, Long.class);

    private BlockFilters() {
    }
}
