package ru.yandex.partner.core.entity.block.filter;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import org.jooq.Condition;
import org.jooq.Field;
import org.jooq.impl.DSL;

import ru.yandex.partner.core.filter.FilterType;
import ru.yandex.partner.core.filter.dbmeta.BaseFilter;
import ru.yandex.partner.core.filter.operator.FilterOperator;
import ru.yandex.partner.core.filter.utils.FilterUtils;

// Пока поставлено ограничение на enum, если появятся другие типы,
// то нужно будет сделать доп иерархию или переделать тип на enum %)
public class SiteVersionFilter<M, T extends Enum<T>> extends BaseFilter<M, String> {
    private final Class<T> enumClass;
    private final Field<T> field;

    public SiteVersionFilter(String name, Class<M> modelClass, Class<T> enumClass, Field<T> field) {
        super(name, FilterType.DICTIONARY, modelClass, String.class);
        this.enumClass = enumClass;
        this.field = field;
    }

    @Override
    public Condition getCondition(FilterOperator operator, Collection<String> value) {
        List<T> validValues = value.stream()
                .map(siteVersion -> {
                            try {
                                return Enum.valueOf(enumClass, siteVersion);
                            } catch (IllegalArgumentException e) {
                                return null;
                            }
                        }
                )
                .filter(Objects::nonNull)
                .collect(Collectors.toList());

        if (validValues.isEmpty()) {
            return DSL.falseCondition();
        } else {
            return FilterUtils.getConditionInternal(field, operator, validValues);
        }
    }
}
