package ru.yandex.partner.core.entity.block.filter.content;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.ContentBlock;
import ru.yandex.partner.core.filter.db.NoDbFilter;

@Configuration
public class ContentBlockFilterConfiguration {

    @Bean
    public NoDbFilter<ContentBlock, Long> contentBlockAppIdFilter() {
        return new NoDbFilter<>(BlockFilters.APP_ID, ContentBlock.class);
    }

    @Bean
    public NoDbFilter<ContentBlock, Long> contentBlockClientIdFilter() {
        return new NoDbFilter<>(BlockFilters.CLIENT_ID, ContentBlock.class);
    }

    @Bean
    public NoDbFilter<ContentBlock, String> contentBlockDomainFilter() {
        return new NoDbFilter<>(BlockFilters.DOMAIN, ContentBlock.class);
    }

    @Bean
    public NoDbFilter<ContentBlock, Long> contentBlockPlatformFilter() {
        return new NoDbFilter<>(BlockFilters.PLATFORM, ContentBlock.class);
    }
}
