package ru.yandex.partner.core.entity.block.filter.content;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.ContentBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class ContentBlockIsYandexAliasDbFilter extends AliasDbFilter<ContentBlock, Boolean> {

    @Autowired
    public ContentBlockIsYandexAliasDbFilter(ContentBlockPageMatchDbFilter contentBlockPageMatchDbFilter) {
        super(BlockFilters.IS_YANDEX_BLOCK, ContentBlock.class, contentBlockPageMatchDbFilter, PageFilters.OWNER,
                UserFilters.IS_YANDEX_FILTER);
    }
}
