package ru.yandex.partner.core.entity.block.filter.content;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.ContentBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class ContentBlockLoginAliasDbFilter extends AliasDbFilter<ContentBlock, String> {

    @Autowired
    public ContentBlockLoginAliasDbFilter(ContentBlockPageMatchDbFilter contentBlockPageMatchDbFilter) {
        super(BlockFilters.LOGIN, ContentBlock.class, contentBlockPageMatchDbFilter,
                PageFilters.OWNER, UserFilters.LOGIN);
    }
}
