package ru.yandex.partner.core.entity.block.filter.content;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.ContentBlock;
import ru.yandex.partner.core.entity.block.multistate.ContentBlockMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class ContentBlockMultistateDbFilter extends MultistateDbFilter<ContentBlock, BlockStateFlag> {

    @Autowired
    public ContentBlockMultistateDbFilter(ContentBlockMultistateGraph multistateGraph) {
        super(BlockFilters.MULTISTATE, ContentBlock.class, multistateGraph,
                CONTEXT_ON_SITE_RTB.MULTISTATE);
    }
}
