package ru.yandex.partner.core.entity.block.filter.content;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.ContentBlock;
import ru.yandex.partner.core.entity.page.filter.PageModelFilterContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class ContentBlockPageMatchDbFilter extends MatchDbFilter<ContentBlock, BasePage, ContextPage> {

    private PageModelFilterContainer pageModelFilterContainer;

    @Autowired
    public ContentBlockPageMatchDbFilter() {
        super(BlockFilters.PAGE, ContentBlock.class, ContextPage.class,
                ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.CAMPAIGN_ID, PAGES.ID);
    }

    @Autowired
    public void setPageModelFilterContainer(PageModelFilterContainer pageModelFilterContainer) {
        this.pageModelFilterContainer = pageModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<? super ContextPage> getModelFilterContainer() {
        return pageModelFilterContainer;
    }
}
