package ru.yandex.partner.core.entity.block.filter.external;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.filter.db.NoDbFilter;

@Configuration
public class RtbBlockFilterConfiguration {

    @Bean
    public NoDbFilter<RtbBlock, Long> rtbBlockAppIdFilter() {
        return new NoDbFilter<>(BlockFilters.APP_ID, RtbBlock.class);
    }

    @Bean
    public NoDbFilter<RtbBlock, Long> rtbBlockClientIdFilter() {
        return new NoDbFilter<>(BlockFilters.CLIENT_ID, RtbBlock.class);
    }

    @Bean
    public NoDbFilter<RtbBlock, String> rtbBlockDomainFilter() {
        return new NoDbFilter<>(BlockFilters.DOMAIN, RtbBlock.class);
    }

    @Bean
    public NoDbFilter<RtbBlock, Long> rtbBlockPlatformFilter() {
        return new NoDbFilter<>(BlockFilters.PLATFORM, RtbBlock.class);
    }
}
