package ru.yandex.partner.core.entity.block.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class RtbBlockIsYandexAliasDbFilter extends AliasDbFilter<RtbBlock, Boolean> {

    @Autowired
    public RtbBlockIsYandexAliasDbFilter(RtbBlockPageMatchDbFilter rtbBlockPageMatchDbFilter) {
        super(BlockFilters.IS_YANDEX_BLOCK, RtbBlock.class, rtbBlockPageMatchDbFilter, PageFilters.OWNER,
                UserFilters.IS_YANDEX_FILTER);
    }
}
