package ru.yandex.partner.core.entity.block.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.block.multistate.RtbBlockMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class RtbBlockMultistateDbFilter extends MultistateDbFilter<RtbBlock, BlockStateFlag> {

    @Autowired
    public RtbBlockMultistateDbFilter(RtbBlockMultistateGraph multistateGraph) {
        super(BlockFilters.MULTISTATE, RtbBlock.class, multistateGraph,
                CONTEXT_ON_SITE_RTB.MULTISTATE);
    }
}
