package ru.yandex.partner.core.entity.block.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageModelFilterContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.ContextPage;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class RtbBlockPageMatchDbFilter extends MatchDbFilter<RtbBlock, BasePage, ContextPage> {

    private PageModelFilterContainer pageModelFilterContainer;

    @Autowired
    public RtbBlockPageMatchDbFilter() {
        super(BlockFilters.PAGE, RtbBlock.class, ContextPage.class,
                ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.CAMPAIGN_ID, PAGES.ID);
    }

    @Autowired
    public void setPageModelFilterContainer(PageModelFilterContainer pageModelFilterContainer) {
        this.pageModelFilterContainer = pageModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<? super ContextPage> getModelFilterContainer() {
        return pageModelFilterContainer;
    }
}
