package ru.yandex.partner.core.entity.block.filter.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.RtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.filter.UserType;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class RtbBlockUserTypeAliasDbFilter extends AliasDbFilter<RtbBlock, UserType> {

    @Autowired
    public RtbBlockUserTypeAliasDbFilter(RtbBlockPageMatchDbFilter rtbBlockPageMatchDbFilter) {
        super(BlockFilters.USER_TYPE, RtbBlock.class, rtbBlockPageMatchDbFilter, PageFilters.OWNER,
                UserFilters.USER_TYPE);
    }
}
