package ru.yandex.partner.core.entity.block.filter.internal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.filter.db.NoDbFilter;

@Configuration
public class InternalRtbBlockFilterConfiguration {

    @Bean
    public NoDbFilter<InternalRtbBlock, Long> internalRtbBlockAppIdFilter() {
        return new NoDbFilter<>(BlockFilters.APP_ID, InternalRtbBlock.class);
    }

    @Bean
    public NoDbFilter<InternalRtbBlock, Long> internalRtbBlockClientIdFilter() {
        return new NoDbFilter<>(BlockFilters.CLIENT_ID, InternalRtbBlock.class);
    }

    @Bean
    public NoDbFilter<InternalRtbBlock, String> internalRtbBlockDomainFilter() {
        return new NoDbFilter<>(BlockFilters.DOMAIN, InternalRtbBlock.class);
    }

    @Bean
    public NoDbFilter<InternalRtbBlock, Long> internalRtbBlockPlatformFilter() {
        return new NoDbFilter<>(BlockFilters.PLATFORM, InternalRtbBlock.class);
    }
}
