package ru.yandex.partner.core.entity.block.filter.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalRtbBlockMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class InternalRtbBlockMultistateDbFilter extends MultistateDbFilter<InternalRtbBlock, BlockStateFlag> {

    @Autowired
    public InternalRtbBlockMultistateDbFilter(InternalRtbBlockMultistateGraph multistateGraph) {
        super(BlockFilters.MULTISTATE, InternalRtbBlock.class, multistateGraph,
                CONTEXT_ON_SITE_RTB.MULTISTATE);
    }
}
