package ru.yandex.partner.core.entity.block.filter.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class MobileRtbBlockClientIdAliasDbFilter extends AliasDbFilter<MobileRtbBlock, Long> {

    @Autowired
    public MobileRtbBlockClientIdAliasDbFilter(MobileRtbBlockPageMatchDbFilter mobileRtbBlockPageMatchDbFilter) {
        super(BlockFilters.CLIENT_ID, MobileRtbBlock.class, mobileRtbBlockPageMatchDbFilter,
                PageFilters.OWNER, UserFilters.CLIENT_ID);
    }
}
