package ru.yandex.partner.core.entity.block.filter.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class MobileRtbBlockIsYandexAliasDbFilter extends AliasDbFilter<MobileRtbBlock, Boolean> {

    @Autowired
    public MobileRtbBlockIsYandexAliasDbFilter(MobileRtbBlockPageMatchDbFilter mobileRtbBlockPageMatchDbFilter) {
        super(BlockFilters.IS_YANDEX_BLOCK, MobileRtbBlock.class, mobileRtbBlockPageMatchDbFilter,
                PageFilters.OWNER, UserFilters.IS_YANDEX_FILTER);
    }
}
