package ru.yandex.partner.core.entity.block.filter.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class MobileRtbBlockLoginAliasDbFilter extends AliasDbFilter<MobileRtbBlock, String> {

    @Autowired
    public MobileRtbBlockLoginAliasDbFilter(MobileRtbBlockPageMatchDbFilter mobileRtbBlockPageMatchDbFilter) {
        super(BlockFilters.LOGIN, MobileRtbBlock.class, mobileRtbBlockPageMatchDbFilter,
                PageFilters.OWNER, UserFilters.LOGIN);
    }
}
