package ru.yandex.partner.core.entity.block.filter.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.MobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class MobileRtbBlockMultistateDbFilter extends MultistateDbFilter<MobileRtbBlock, BlockStateFlag> {

    @Autowired
    public MobileRtbBlockMultistateDbFilter(MobileRtbBlockMultistateGraph multistateGraph) {
        super(BlockFilters.MULTISTATE, MobileRtbBlock.class, multistateGraph, CONTEXT_ON_SITE_RTB.MULTISTATE);
    }
}
