package ru.yandex.partner.core.entity.block.filter.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageModelFilterContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.MobileAppSettings;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.Tables;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class MobileRtbBlockPageMatchDbFilter extends MatchDbFilter<MobileRtbBlock, BasePage, MobileAppSettings> {

    private PageModelFilterContainer pageModelFilterContainer;

    @Autowired
    public MobileRtbBlockPageMatchDbFilter() {
        super(BlockFilters.PAGE, MobileRtbBlock.class, MobileAppSettings.class,
                Tables.CONTEXT_ON_SITE_RTB.CAMPAIGN_ID, PAGES.ID);
    }

    @Autowired
    public void setMobileAppSettingsModelFilterContainer(
            PageModelFilterContainer pageModelFilterContainer) {
        this.pageModelFilterContainer = pageModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<? super MobileAppSettings> getModelFilterContainer() {
        return pageModelFilterContainer;
    }
}
