package ru.yandex.partner.core.entity.block.filter.mobile.external;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.MobileRtbBlock;
import ru.yandex.partner.core.entity.domain.filter.DomainFilters;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class MobileRtbBlockPlatformAliasDbFilter extends AliasDbFilter<MobileRtbBlock, Long> {

    @Autowired
    public MobileRtbBlockPlatformAliasDbFilter(MobileRtbBlockPageMatchDbFilter mobileRtbBlockPageMatchDbFilter) {
        super(BlockFilters.PLATFORM, MobileRtbBlock.class, mobileRtbBlockPageMatchDbFilter,
                PageFilters.DOMAIN, DomainFilters.TYPE);
    }
}
