package ru.yandex.partner.core.entity.block.filter.mobile.internal;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.filter.db.NoDbFilter;

@Configuration
public class InternalMobileRtbBlockFilterConfiguration {

    @Bean
    public NoDbFilter<InternalMobileRtbBlock, Long> internalMobileRtbBlockAppIdFilter() {
        return new NoDbFilter<>(BlockFilters.APP_ID, InternalMobileRtbBlock.class);
    }

    @Bean
    public NoDbFilter<InternalMobileRtbBlock, Long> internalMobileRtbBlockClientIdFilter() {
        return new NoDbFilter<>(BlockFilters.CLIENT_ID, InternalMobileRtbBlock.class);
    }

    @Bean
    public NoDbFilter<InternalMobileRtbBlock, String> internalMobileRtbBlockDomainFilter() {
        return new NoDbFilter<>(BlockFilters.DOMAIN, InternalMobileRtbBlock.class);
    }

    @Bean
    public NoDbFilter<InternalMobileRtbBlock, Long> internalMobileRtbBlockPlatformFilter() {
        return new NoDbFilter<>(BlockFilters.PLATFORM, InternalMobileRtbBlock.class);
    }
}
