package ru.yandex.partner.core.entity.block.filter.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class InternalMobileRtbBlockIsYandexAliasDbFilter extends AliasDbFilter<InternalMobileRtbBlock, Boolean> {

    @Autowired
    public InternalMobileRtbBlockIsYandexAliasDbFilter(
            InternalMobileRtbBlockPageMatchDbFilter internalRtbBlockPageMatchDbFilter) {
        super(BlockFilters.IS_YANDEX_BLOCK, InternalMobileRtbBlock.class, internalRtbBlockPageMatchDbFilter,
                PageFilters.OWNER, UserFilters.IS_YANDEX_FILTER);
    }
}
