package ru.yandex.partner.core.entity.block.filter.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.block.multistate.InternalMobileRtbBlockMultistateGraph;
import ru.yandex.partner.core.filter.db.MultistateDbFilter;
import ru.yandex.partner.core.multistate.block.BlockStateFlag;

import static ru.yandex.partner.dbschema.partner.Tables.CONTEXT_ON_SITE_RTB;

@Component
public class InternalMobileRtbBlockMultistateDbFilter
        extends MultistateDbFilter<InternalMobileRtbBlock, BlockStateFlag> {

    @Autowired
    public InternalMobileRtbBlockMultistateDbFilter(InternalMobileRtbBlockMultistateGraph multistateGraph) {
        super(BlockFilters.MULTISTATE, InternalMobileRtbBlock.class, multistateGraph,
                CONTEXT_ON_SITE_RTB.MULTISTATE);
    }
}
