package ru.yandex.partner.core.entity.block.filter.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageModelFilterContainer;
import ru.yandex.partner.core.entity.page.model.BasePage;
import ru.yandex.partner.core.entity.page.model.InternalMobileApp;
import ru.yandex.partner.core.filter.container.ModelFilterContainer;
import ru.yandex.partner.core.filter.db.MatchDbFilter;
import ru.yandex.partner.dbschema.partner.tables.ContextOnSiteRtb;

import static ru.yandex.partner.dbschema.partner.Tables.PAGES;

@Component
public class InternalMobileRtbBlockPageMatchDbFilter
        extends MatchDbFilter<InternalMobileRtbBlock, BasePage, InternalMobileApp> {

    private PageModelFilterContainer pageModelFilterContainer;

    @Autowired
    public InternalMobileRtbBlockPageMatchDbFilter() {
        super(BlockFilters.PAGE, InternalMobileRtbBlock.class, InternalMobileApp.class,
                ContextOnSiteRtb.CONTEXT_ON_SITE_RTB.CAMPAIGN_ID, PAGES.ID);
    }

    @Autowired
    public void setInternalPageModelFilterContainer(PageModelFilterContainer pageModelFilterContainer) {
        this.pageModelFilterContainer = pageModelFilterContainer;
    }

    @Override
    protected ModelFilterContainer<? super InternalMobileApp> getModelFilterContainer() {
        return pageModelFilterContainer;
    }
}
