package ru.yandex.partner.core.entity.block.filter.mobile.internal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.partner.core.entity.block.filter.BlockFilters;
import ru.yandex.partner.core.entity.block.model.InternalMobileRtbBlock;
import ru.yandex.partner.core.entity.page.filter.PageFilters;
import ru.yandex.partner.core.entity.user.filter.UserFilters;
import ru.yandex.partner.core.entity.user.filter.UserType;
import ru.yandex.partner.core.filter.db.AliasDbFilter;

@Component
public class InternalMobileRtbBlockUserTypeAliasDbFilter extends AliasDbFilter<InternalMobileRtbBlock, UserType> {

    @Autowired
    public InternalMobileRtbBlockUserTypeAliasDbFilter(
            InternalMobileRtbBlockPageMatchDbFilter internalRtbBlockPageMatchDbFilter) {
        super(BlockFilters.USER_TYPE, InternalMobileRtbBlock.class,
                internalRtbBlockPageMatchDbFilter, PageFilters.OWNER,
                UserFilters.USER_TYPE);
    }
}
