package ru.yandex.partner.core.entity.block.formats

data class MediaFormat(
    val square: Int,
    val height: Int,
    val percent: String,
    val width: Int
) {

    companion object {
        fun buildMediaFormat(dspBlock: String): MediaFormat? {
            return "^(\\d+)(%?)x(\\d+)\$".toRegex().matchEntire(dspBlock)?.let {
                val (_, widthStr, percent, heightStr) = it.groupValues
                val width = widthStr.toInt()
                val height = heightStr.toInt()

                if (percent.isNotBlank()) {
                    MediaFormat(
                        square = height,
                        height = height,
                        percent = percent,
                        width = width
                    )
                } else {
                    MediaFormat(
                        square = width * height,
                        height = height,
                        percent = percent,
                        width = width
                    )
                }
            }
        }
    }

}
