package ru.yandex.partner.core.entity.block.multistate;

import java.util.Objects;

import ru.yandex.partner.core.entity.page.model.PageWithBlocksLimit;

public class ActionChecksUtils {
    private ActionChecksUtils() { }

    public static boolean isBlocksLimitNotExceeded(PageWithBlocksLimit page) {
        String msg = "%s is not loaded for page " + page.getId();
        return Objects.requireNonNull(page.getBlocksLimit(), msg.formatted("blocks_limit")) >
                Objects.requireNonNull(page.getBlocksCount(), msg.formatted("blocks_count"));
    }
}
